# 📦 Installation Guide for Camera Roll Bin Creator

## ⚙️ Prerequisites
- **DaVinci Resolve** (Free or Studio), **v17+**
- No external dependencies required when run from the **Scripts menu**
- (Optional) Enable Resolve’s scripting over TCP/IP **only** if you plan to run external tools

## 📁 Installation Steps

1. **Locate the DaVinci Resolve Scripts Directory**

   Use the **Edit** scripts folder so the tool appears under *Workspace → Scripts → Edit*.

   - **macOS**
     ```
     ~/Library/Application Support/Blackmagic Design/DaVinci Resolve/Fusion/Scripts/Edit/
     ```
   - **Windows**
     ```
     %AppData%/Blackmagic Design/DaVinci Resolve/Fusion/Scripts/Edit/
     ```
     (Example: `C:/Users/<YourUser>/AppData/Roaming/Blackmagic Design/DaVinci Resolve/Fusion/Scripts/Edit/`)
   - **Linux**
     ```
     ~/.local/share/BlackmagicDesign/DaVinci Resolve/Fusion/Scripts/Edit/
     ```

2. **Place the Script**
   - Copy the file **`Create_CameraRoll_Bins.py`** into the **Scripts/Edit/** directory above.

3. **(Optional) Add an Icon**
   - You can add a 24×24 PNG next to the script with the same base name (e.g., `Create_CameraRoll_Bins.png`) to show a custom icon in the Scripts menu.

---

## 🚀 Running the Script

1. Open **DaVinci Resolve** and your project.
2. In the **Media Pool**, **select the parent bin** where you want the roll/card bins to be created.
   *(If nothing is selected, the script uses the **Root** bin.)*
3. Go to:
   ```
   Workspace → Scripts → Edit → Create_CameraRoll_Bins
   ```
4. In the dialog, set:
   - **How many bins** to create
   - **Digits (padding)** — e.g., `3` → `A001`
   - **Start index** — e.g., `101` → starts at `A101`
   - **Starting letter** — single letter (e.g., `A`)
5. Click **OK**. The bins are generated instantly.

**Examples**
- Letter `A`, Digits `3`, Count `10`, Start `1` → `A001 … A010`
- Letter `B`, Digits `3`, Count `5`, Start `101` → `B101 … B105`

---

## 💡 Notes & Behavior
- Bins are created **under the currently selected Media Pool folder**; if none is selected, **Root** is used.
- Existing bins with the same name are **skipped safely** (no duplicates).
- The operation is grouped into a **single Undo step** where supported by your Resolve build.

---

## 🧩 Troubleshooting

**Script not visible under “Scripts → Edit”**
- Confirm the script is in the correct folder for your OS (paths above).
- Restart Resolve after adding new scripts.
- On macOS, ensure you used your **user Library** path (`~/Library/...`) not the system `/Library/...` path.
 
**Undo doesn’t group all created bins**
- Some Resolve builds don’t fully support the compound undo API. The script includes a safe fallback; behavior may vary by version.

---

## 🔐 Optional: External Scripting (Advanced)
Only needed if you plan to control Resolve from **outside** (e.g., a separate Python app with Tkinter):
- Enable **Preferences → System → General → External scripting using TCP/IP** and restart Resolve.

---

## 📧 Support
For assistance or feedback, contact **Daniel Bañuelos**:  
**Email:** dany.b@dandbc.mx  
**More tools:** https://dandbc.mx/tools
